<?php
// public/tutor/dashboard.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('tutor');

$tid = $_SESSION['user_id'];
$stats = [
    'total' => $conn->query("SELECT COUNT(*) FROM bookings WHERE tutor_id=$tid")->fetch_row()[0],
    'pending' => $conn->query("SELECT COUNT(*) FROM bookings WHERE tutor_id=$tid AND status='pending'")->fetch_row()[0],
    'approved' => $conn->query("SELECT COUNT(*) FROM bookings WHERE tutor_id=$tid AND status='approved'")->fetch_row()[0],
];

tailwind_head("Tutor Dashboard");
?>
<?php
// public/tutor/dashboard.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('tutor');

// ... PHP Logic ...

tailwind_head("Tutor Dashboard");
?>
<?php include '_nav.php'; ?>

<div class="mx-auto max-w-7xl px-4">
<div class="mx-auto max-w-7xl px-4">
    <h2 class="text-2xl font-bold mb-6">Welcome, <?= e(user()['name']) ?></h2>
    
    <div class="grid grid-cols-1 gap-6 sm:grid-cols-3">
        <div class="bg-white overflow-hidden shadow rounded-lg p-5">
            <dt class="text-sm font-medium text-slate-500 truncate">Total Bookings</dt>
            <dd class="mt-1 text-3xl font-semibold text-slate-900"><?= $stats['total'] ?></dd>
        </div>
        <div class="bg-white overflow-hidden shadow rounded-lg p-5">
            <dt class="text-sm font-medium text-slate-500 truncate">Pending Approval</dt>
            <dd class="mt-1 text-3xl font-semibold text-yellow-600"><?= $stats['pending'] ?></dd>
        </div>
        <div class="bg-white overflow-hidden shadow rounded-lg p-5">
            <dt class="text-sm font-medium text-slate-500 truncate">Approved</dt>
            <dd class="mt-1 text-3xl font-semibold text-green-600"><?= $stats['approved'] ?></dd>
        </div>
    </div>

    <div class="mt-10">
        <a href="book.php" class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500">
            <i class="fas fa-plus mr-2"></i> Create New Booking
        </a>
    </div>
</div>
<?php tailwind_foot(); ?>