<?php
// public/tutor/book.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('tutor');

// Use the mobile-friendly nav
include '_nav.php';

$msg = '';
$error = '';

// Load Dropdown Data
$labs = $conn->query("SELECT * FROM labs WHERE status = 'available'")->fetch_all(MYSQLI_ASSOC);
$classes = $conn->query("SELECT * FROM batches WHERE is_active = 1")->fetch_all(MYSQLI_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 1. Capture Inputs
    $lab_id = $_POST['lab_id'];
    $class_id = !empty($_POST['class_id']) ? $_POST['class_id'] : null;
    $sections = (int)$_POST['sections'];
    $expected = !empty($_POST['expected']) ? (int)$_POST['expected'] : null;
    $purpose = $_POST['purpose'];
    $notes = trim($_POST['notes']);
    
    // 2. Handle Course (Find or Create)
    $course_name = trim($_POST['course_name']);
    $course_id = null;
    
    $stmt_c = $conn->prepare("SELECT id FROM courses WHERE name = ?");
    $stmt_c->bind_param("s", $course_name);
    $stmt_c->execute();
    $res_c = $stmt_c->get_result();
    
    if ($row_c = $res_c->fetch_assoc()) {
        $course_id = $row_c['id'];
    } else {
        $stmt_new = $conn->prepare("INSERT INTO courses (name, code, is_active) VALUES (?, 'AUTO', 1)");
        $stmt_new->bind_param("s", $course_name);
        if($stmt_new->execute()) $course_id = $stmt_new->insert_id;
    }

    // 3. Process Times
    $start_time = str_replace('T', ' ', $_POST['start_time']) . ':00';
    $end_time = str_replace('T', ' ', $_POST['end_time']) . ':00';

    // 4. Check Overlaps
    if (overlap_exists($lab_id, $start_time, $end_time)) {
        $error = "This time slot overlaps with an existing booking.";
    } else {
        // 5. Insert Booking
        $tid = $_SESSION['user_id'];
        $status = 'pending';
        
        // SQL: 11 Placeholders
        $sql = "INSERT INTO bookings (tutor_id, lab_id, course_id, batch_id, purpose, expected_students, sections, start_time, end_time, notes, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        // Types: 11 Characters (i=integer, s=string)
        // 1.tid(i) 2.lab(i) 3.course(i) 4.class(i) 5.purpose(s) 6.expected(i) 7.sections(i) 8.start(s) 9.end(s) 10.notes(s) 11.status(s)
        $types = 'iiiisiissss';
        
        $stmt = $conn->prepare($sql);
        
        // Bind: 11 Variables matching the order above exactly
        $stmt->bind_param($types, $tid, $lab_id, $course_id, $class_id, $purpose, $expected, $sections, $start_time, $end_time, $notes, $status);
        
        if ($stmt->execute()) {
            $msg = "Booking submitted successfully.";
            
            // 6. NOTIFY ADMINS (The missing piece!)
            // Get current tutor name
            $tutor_name = $_SESSION['user']['name'] ?? 'Tutor';
            
            // Find all admins and send them a notification
            $admins = $conn->query("SELECT id FROM users WHERE role='admin'");
            while($admin = $admins->fetch_assoc()) {
                notify($admin['id'], "New Booking: $course_name by $tutor_name", "admin/bookings.php");
            }

        } else {
            $error = "Error: " . $conn->error;
        }
    }
}

tailwind_head("Book Lab");
?>

<div class="mx-auto max-w-3xl px-4 pb-10">
    <h2 class="text-2xl font-bold mb-6">Book a Lab</h2>
    
    <?php if($msg): ?><div class="p-4 mb-4 text-green-700 bg-green-100 rounded"><?= e($msg) ?></div><?php endif; ?>
    <?php if($error): ?><div class="p-4 mb-4 text-red-700 bg-red-100 rounded"><?= e($error) ?></div><?php endif; ?>

    <form method="POST" class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-8 space-y-6">
        <div class="grid grid-cols-1 gap-x-6 gap-y-4 sm:grid-cols-2">
            
            <div>
                <label class="block text-sm font-medium leading-6 text-slate-900">Lab</label>
                <select name="lab_id" required class="mt-2 block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300 focus:ring-2 focus:ring-indigo-600">
                    <?php foreach($labs as $l): ?><option value="<?= $l['id'] ?>"><?= e($l['name']) ?></option><?php endforeach; ?>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium leading-6 text-slate-900">Course Name</label>
                <input type="text" name="course_name" required placeholder="e.g. Intro to Nursing" class="mt-2 block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300 focus:ring-2 focus:ring-indigo-600">
            </div>

            <div>
                <label class="block text-sm font-medium leading-6 text-slate-900">Class</label>
                <select name="class_id" class="mt-2 block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300 focus:ring-2 focus:ring-indigo-600">
                    <option value="">-- None --</option>
                    <?php foreach($classes as $b): ?><option value="<?= $b['id'] ?>"><?= e($b['name']) ?></option><?php endforeach; ?>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium leading-6 text-slate-900">Purpose</label>
                <select name="purpose" required class="mt-2 block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300 focus:ring-2 focus:ring-indigo-600">
                    <option value="Quiz">Quiz</option>
                    <option value="Mid-semester">Mid-semester</option>
                    <option value="Exam">Exam</option>
                    <option value="Practical">Practical</option>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium leading-6 text-slate-900">Sections</label>
                <input type="number" name="sections" value="1" min="1" class="mt-2 block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300">
            </div>
            <div>
                <label class="block text-sm font-medium leading-6 text-slate-900">Expected Students</label>
                <input type="number" name="expected" class="mt-2 block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300">
            </div>

            <div>
                <label class="block text-sm font-medium leading-6 text-slate-900">Start Time</label>
                <input type="datetime-local" name="start_time" required class="mt-2 block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300">
            </div>
            <div>
                <label class="block text-sm font-medium leading-6 text-slate-900">End Time</label>
                <input type="datetime-local" name="end_time" required class="mt-2 block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300">
            </div>
            
            <div class="col-span-full">
                <label class="block text-sm font-medium leading-6 text-slate-900">Additional Comments (Optional)</label>
                <textarea name="notes" rows="2" class="mt-2 block w-full rounded-md border-0 py-1.5 shadow-sm ring-1 ring-inset ring-slate-300 focus:ring-2 focus:ring-indigo-600"></textarea>
            </div>
        </div>

        <div class="mt-6 flex justify-end">
            <button type="submit" class="rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500">Submit Booking</button>
        </div>
    </form>
</div>
<?php tailwind_foot(); ?>