<?php
// public/notifications.php
require_once '../config/db.php';
require_once '../lib/functions.php';
require_login();

$uid = $_SESSION['user_id'];

// 1. Mark all notifications as read immediately
$conn->query("UPDATE notifications SET is_read = 1 WHERE user_id = $uid");

// 2. Fetch notifications
$notifs = $conn->query("SELECT * FROM notifications WHERE user_id = $uid ORDER BY created_at DESC LIMIT 50");

// 3. Determine Role
$is_admin = ($_SESSION['user_role'] === 'admin');

tailwind_head("Notifications");
?>

<?php if ($is_admin): ?>
    <?php include 'admin/_sidebar.php'; ?>
    
    <div class="lg:pl-72 min-h-screen bg-slate-50">
        <main class="py-10 px-4 sm:px-6 lg:px-8">
            <h1 class="text-2xl font-bold mb-6 text-slate-900">Notifications</h1>
            
            <div class="bg-white shadow overflow-hidden sm:rounded-md border border-slate-200">
                <ul role="list" class="divide-y divide-slate-200">
                    <?php while($row = $notifs->fetch_assoc()): ?>
                    <li>
                        <a href="<?= $row['link'] ? e($row['link']) : '#' ?>" class="block hover:bg-slate-50 transition duration-150 ease-in-out">
                            <div class="px-4 py-4 sm:px-6">
                                <div class="flex items-center justify-between">
                                    <p class="truncate text-sm font-medium text-indigo-600"><?= e($row['message']) ?></p>
                                    <div class="ml-2 flex flex-shrink-0">
                                        <p class="text-xs text-slate-500"><?= date('M d, H:i', strtotime($row['created_at'])) ?></p>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </li>
                    <?php endwhile; ?>
                    
                    <?php if($notifs->num_rows == 0): ?>
                        <li class="px-4 py-12 text-center text-slate-500">
                            <i class="fas fa-bell-slash text-4xl mb-3 text-slate-300"></i>
                            <p>No notifications yet.</p>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </main>
    </div>

<?php else: ?>
    <?php include 'tutor/_nav.php'; ?>
    
    <div class="mx-auto max-w-7xl px-4 py-10">
        <h1 class="text-2xl font-bold mb-6 text-slate-900">Notifications</h1>
        
        <div class="bg-white shadow overflow-hidden sm:rounded-md border border-slate-200">
            <ul role="list" class="divide-y divide-slate-200">
                <?php while($row = $notifs->fetch_assoc()): ?>
                <li>
                    <a href="<?= $row['link'] ? e($row['link']) : '#' ?>" class="block hover:bg-slate-50 transition duration-150 ease-in-out">
                        <div class="px-4 py-4 sm:px-6">
                            <div class="flex items-center justify-between">
                                <p class="truncate text-sm font-medium text-indigo-600"><?= e($row['message']) ?></p>
                                <div class="ml-2 flex flex-shrink-0">
                                    <p class="text-xs text-slate-500"><?= date('M d, H:i', strtotime($row['created_at'])) ?></p>
                                </div>
                            </div>
                        </div>
                    </a>
                </li>
                <?php endwhile; ?>
                
                <?php if($notifs->num_rows == 0): ?>
                    <li class="px-4 py-12 text-center text-slate-500">
                        <i class="fas fa-bell-slash text-4xl mb-3 text-slate-300"></i>
                        <p>No notifications yet.</p>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

<?php endif; ?>

<?php tailwind_foot(); ?>