<?php
// public/admin/users.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('admin');

$msg = '';
$err = '';

// Handle Actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // 1. Create User
    if (isset($_POST['action']) && $_POST['action'] === 'create') {
        // ... (Same logic as before) ...
        $name = trim($_POST['name']);
        $email = trim($_POST['email']);
        $role = $_POST['role'];
        $password = $_POST['password'];
        $hash = password_hash($password, PASSWORD_BCRYPT);
        
        $stmt = $conn->prepare("INSERT INTO users (name, email, role, password_hash, is_active) VALUES (?, ?, ?, ?, 1)");
        $stmt->bind_param("ssss", $name, $email, $role, $hash);
        if ($stmt->execute()) $msg = "User created.";
        else $err = "Error or Duplicate Email.";
    }

    // 2. Update User
    if (isset($_POST['action']) && $_POST['action'] === 'update') {
        // ... (Same logic as before) ...
        $id = $_POST['id'];
        $role = $_POST['role'];
        $active = isset($_POST['is_active']) ? 1 : 0;
        
        $sql = "UPDATE users SET role=?, is_active=? WHERE id=?";
        $params = [$role, $active, $id];
        $types = "sii";

        if (!empty($_POST['new_password'])) {
            $hash = password_hash($_POST['new_password'], PASSWORD_BCRYPT);
            $sql = "UPDATE users SET role=?, is_active=?, password_hash=? WHERE id=?";
            $params = [$role, $active, $hash, $id];
            $types = "sisi";
        }
        $stmt = $conn->prepare($sql);
        $stmt->bind_param($types, ...$params);
        if($stmt->execute()) $msg = "User updated.";
    }

    // 3. NEW: Delete User
    if (isset($_POST['action']) && $_POST['action'] === 'delete') {
        $id = $_POST['id'];
        if ($id == $_SESSION['user_id']) {
            $err = "You cannot delete your own account.";
        } else {
            $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
            $stmt->bind_param("i", $id);
            if ($stmt->execute()) $msg = "User deleted successfully.";
            else $err = "Error deleting user.";
        }
    }
}

$users = $conn->query("SELECT * FROM users ORDER BY created_at DESC");

tailwind_head("Manage Users");
?>
<div>
    <?php include '_sidebar.php'; ?>
    <div class="lg:pl-72">
        <main class="py-10 px-4 sm:px-6 lg:px-8">
            <h1 class="text-2xl font-bold mb-6">Manage Users</h1>
            <?php if($msg): ?><div class="bg-green-100 text-green-700 p-3 mb-4 rounded"><?= e($msg) ?></div><?php endif; ?>
            <?php if($err): ?><div class="bg-red-100 text-red-700 p-3 mb-4 rounded"><?= e($err) ?></div><?php endif; ?>

            <div class="bg-white p-6 rounded-lg shadow mb-8 border border-slate-200">
                <h2 class="text-lg font-bold text-slate-800 mb-4"><i class="fas fa-user-plus mr-2"></i> Create New User</h2>
                <form method="POST" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4 items-end">
                    <input type="hidden" name="action" value="create">
                    <input type="text" name="name" placeholder="Name" required class="border p-2 rounded w-full">
                    <input type="email" name="email" placeholder="Email" required class="border p-2 rounded w-full">
                    <select name="role" class="border p-2 rounded w-full"><option value="tutor">Tutor</option><option value="admin">Admin</option></select>
                    <input type="text" name="password" placeholder="Password" required class="border p-2 rounded w-full">
                    <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded">Create</button>
                </form>
            </div>
            
            <input type="text" id="liveSearch" onkeyup="tableSearch()" placeholder="Search..." class="border p-2 rounded w-full mb-4 shadow-sm">

            <div class="overflow-x-auto shadow ring-1 ring-black ring-opacity-5 sm:rounded-lg">
                <table class="min-w-full divide-y divide-slate-300">
                    <thead class="bg-slate-50">
                        <tr>
                            <th class="py-3.5 pl-4 text-left text-sm font-semibold text-slate-900">User</th>
                            <th class="px-3 py-3.5 text-left text-sm font-semibold text-slate-900">Role</th>
                            <th class="px-3 py-3.5 text-left text-sm font-semibold text-slate-900">Status</th>
                            <th class="px-3 py-3.5 text-right text-sm font-semibold text-slate-900">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200 bg-white">
                        <?php while($row = $users->fetch_assoc()): ?>
                        <tr>
                            <td class="py-4 pl-4 text-sm">
                                <div class="font-bold text-slate-900"><?= e($row['name']) ?></div>
                                <div class="text-slate-500"><?= e($row['email']) ?></div>
                            </td>
                            <td class="px-3 py-4 text-sm"><?= ucfirst($row['role']) ?></td>
                            <td class="px-3 py-4 text-sm"><?= $row['is_active'] ? 'Active':'Inactive' ?></td>
                            <td class="px-3 py-4 text-right text-sm">
                                <button onclick='openEditModal(<?= json_encode($row) ?>)' class="text-indigo-600 hover:text-indigo-900 mr-3">Edit</button>
                                
                                <form method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this user?');">
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                    <button type="submit" class="text-red-600 hover:text-red-900">Delete</button>
                                </form>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</div>
<?php tailwind_foot(); ?>