<?php
// public/admin/settings.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('admin');

$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reset_semester'])) {
    // Clear all bookings
    if ($conn->query("TRUNCATE TABLE bookings")) {
        $msg = "System reset! All bookings have been cleared. Classes and Users remain.";
    } else {
        $msg = "Error: " . $conn->error;
    }
}

tailwind_head("System Settings");
?>
<div>
    <?php include '_sidebar.php'; ?>
    <div class="lg:pl-72">
        <main class="py-10 px-4 sm:px-6 lg:px-8">
            <h1 class="text-2xl font-bold mb-6 text-red-600">System Settings</h1>
            
            <?php if($msg): ?><div class="bg-green-100 text-green-700 p-3 mb-4 rounded"><?= e($msg) ?></div><?php endif; ?>

            <div class="bg-white p-6 rounded shadow max-w-xl border-l-4 border-red-500">
                <h3 class="text-lg font-bold mb-2">New Semester Reset</h3>
                <p class="text-slate-600 mb-6">
                    This action will <strong>delete all booking history</strong>. 
                    It is used to prepare the system for a new semester. 
                    User accounts, Labs, and Classes will <strong>not</strong> be deleted.
                </p>
                
                <form method="POST" onsubmit="return confirm('Are you sure? This cannot be undone.');">
                    <button type="submit" name="reset_semester" class="bg-red-600 text-white px-4 py-2 rounded shadow hover:bg-red-700">
                        <i class="fas fa-trash-alt mr-2"></i> Clear All Bookings
                    </button>
                </form>
            </div>
        </main>
    </div>
</div>
<?php tailwind_foot(); ?>