<?php
// public/admin/schedule.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('admin');

// Default to today and Lab 1
$date = $_GET['date'] ?? date('Y-m-d');
$lab_id = $_GET['lab_id'] ?? 1;

$labs = $conn->query("SELECT * FROM labs");
$bookings = $conn->query("SELECT b.*, u.name as tutor_name, c.name as course_name 
                          FROM bookings b 
                          JOIN users u ON b.tutor_id = u.id 
                          LEFT JOIN courses c ON b.course_id = c.id
                          WHERE b.lab_id = $lab_id 
                          AND b.status IN ('approved', 'pending')
                          AND DATE(b.start_time) = '$date'
                          ORDER BY b.start_time ASC");

// Build a simple timeline array (8am to 5pm)
$timeline = [];
for($i=8; $i<=17; $i++) $timeline[$i] = null;

// Populate timeline
while($b = $bookings->fetch_assoc()) {
    $start_h = (int)date('H', strtotime($b['start_time']));
    $end_h = (int)date('H', strtotime($b['end_time']));
    for($i = $start_h; $i < $end_h; $i++) {
        if(isset($timeline[$i])) $timeline[$i] = $b;
    }
}

tailwind_head("Lab Schedule");
?>
<div>
    <?php include '_sidebar.php'; ?>
    <div class="lg:pl-72">
        <main class="py-10 px-4 sm:px-6 lg:px-8">
            <h1 class="text-2xl font-bold mb-6">Daily Schedule View</h1>
            
            <form method="GET" class="bg-white p-4 rounded shadow mb-6 flex flex-wrap gap-4 items-end">
                <div>
                    <label class="block text-sm font-medium">Date</label>
                    <input type="date" name="date" value="<?= $date ?>" class="border p-2 rounded w-full">
                </div>
                <div>
                    <label class="block text-sm font-medium">Lab</label>
                    <select name="lab_id" class="border p-2 rounded w-full pr-8">
                        <?php while($l = $labs->fetch_assoc()): ?>
                            <option value="<?= $l['id'] ?>" <?= $l['id'] == $lab_id ? 'selected':'' ?>><?= e($l['name']) ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded">View</button>
            </form>

            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                <div class="px-4 py-5 sm:px-6 border-b border-gray-200">
                    <h3 class="text-lg leading-6 font-medium text-gray-900">Timeline: <?= date('M d, Y', strtotime($date)) ?></h3>
                </div>
                <div class="border-t border-gray-200">
                    <dl>
                        <?php foreach($timeline as $hour => $booking): ?>
                        <div class="bg-white px-4 py-3 grid grid-cols-12 gap-4 sm:px-6 border-b <?= $booking ? ($booking['status']=='approved' ? 'bg-green-50' : 'bg-yellow-50') : '' ?>">
                            <dt class="text-sm font-medium text-gray-500 col-span-2">
                                <?= sprintf("%02d:00", $hour) ?> - <?= sprintf("%02d:00", $hour+1) ?>
                            </dt>
                            <dd class="mt-1 text-sm col-span-10 sm:mt-0">
                                <?php if($booking): ?>
                                    <span class="font-bold text-slate-900"><?= e($booking['course_name'] ?? 'Booking') ?></span>
                                    <span class="text-slate-500"> | <?= e($booking['tutor_name']) ?></span>
                                    <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?= $booking['status']=='approved'?'bg-green-100 text-green-800':'bg-yellow-100 text-yellow-800' ?>">
                                        <?= ucfirst($booking['status']) ?>
                                    </span>
                                <?php else: ?>
                                    <span class="text-gray-400 italic">Available</span>
                                <?php endif; ?>
                            </dd>
                        </div>
                        <?php endforeach; ?>
                    </dl>
                </div>
            </div>
        </main>
    </div>
</div>
<?php tailwind_foot(); ?>