<?php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('admin');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $code = $_POST['code'];
    $name = $_POST['name'];
    $dept_id = $_POST['department_id'] ?: null;
    
    $stmt = $conn->prepare("INSERT INTO courses (code, name, department_id) VALUES (?, ?, ?)");
    $stmt->bind_param("ssi", $code, $name, $dept_id);
    $stmt->execute();
}

$courses = $conn->query("SELECT c.*, d.name as dept FROM courses c LEFT JOIN departments d ON c.department_id = d.id ORDER BY c.code ASC");
$depts = $conn->query("SELECT * FROM departments");

tailwind_head("Courses");
?>
<div>
    <?php include '_sidebar.php'; ?>
    <div class="lg:pl-72">
        <main class="py-10 px-4 sm:px-6 lg:px-8">
            <h1 class="text-2xl font-bold mb-6">Courses</h1>
            
            <form method="POST" class="bg-white p-4 rounded shadow mb-6 flex gap-4 items-end">
                <div>
                    <label class="block text-sm">Code</label>
                    <input name="code" required class="border p-2 rounded w-32">
                </div>
                <div class="flex-grow">
                    <label class="block text-sm">Course Name</label>
                    <input name="name" required class="border p-2 rounded w-full">
                </div>
                <div>
                    <label class="block text-sm">Department</label>
                    <select name="department_id" class="border p-2 rounded w-40">
                        <option value="">-- Any --</option>
                        <?php while($d = $depts->fetch_assoc()): ?>
                            <option value="<?= $d['id'] ?>"><?= e($d['name']) ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <button class="bg-indigo-600 text-white px-4 py-2 rounded">Add</button>
            </form>

            <div class="bg-white shadow rounded overflow-hidden">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Code</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Department</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php while($c = $courses->fetch_assoc()): ?>
                        <tr>
                            <td class="px-6 py-4 text-sm font-medium text-gray-900"><?= e($c['code']) ?></td>
                            <td class="px-6 py-4 text-sm text-gray-500"><?= e($c['name']) ?></td>
                            <td class="px-6 py-4 text-sm text-gray-500"><?= e($c['dept'] ?? '-') ?></td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</div>
<?php tailwind_foot(); ?>