<?php
// public/admin/batches.php
require_once '../../config/db.php';
require_once '../../lib/functions.php';
require_role('admin');

$msg = '';

// Handle Create/Edit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $program = $_POST['program'];
    $year = $_POST['year'];
    $active = isset($_POST['is_active']) ? 1 : 0;
    $id = $_POST['id'] ?? null;

    if ($id) {
        $stmt = $conn->prepare("UPDATE batches SET name=?, program=?, year=?, is_active=? WHERE id=?");
        $stmt->bind_param("sssii", $name, $program, $year, $active, $id);
    } else {
        $stmt = $conn->prepare("INSERT INTO batches (name, program, year, is_active) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("sssi", $name, $program, $year, $active);
    }

    if ($stmt->execute()) {
        $msg = "Batch saved successfully.";
    } else {
        $msg = "Error: " . $conn->error;
    }
}

$batches = $conn->query("SELECT * FROM batches ORDER BY year DESC, name ASC");

tailwind_head("Manage Batches");
?>
<div>
    <?php include '_sidebar.php'; ?>
    <div class="lg:pl-72">
        <main class="py-10 px-4 sm:px-6 lg:px-8">
            <h1 class="text-2xl font-bold mb-6">Manage Batches</h1>
            <?php if($msg): ?><div class="bg-blue-100 text-blue-700 p-3 mb-4 rounded"><?= e($msg) ?></div><?php endif; ?>

            <form method="POST" class="bg-white p-6 rounded shadow mb-8 grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
                <input type="hidden" name="id" id="bid">
                <div>
                    <label class="block text-sm font-medium">Batch Name</label>
                    <input name="name" id="bname" required placeholder="e.g. Diploma 2025 A" class="w-full border p-2 rounded">
                </div>
                <div>
                    <label class="block text-sm font-medium">Program</label>
                    <input name="program" id="bprog" placeholder="Nursing" class="w-full border p-2 rounded">
                </div>
                <div>
                    <label class="block text-sm font-medium">Year</label>
                    <input name="year" id="byear" placeholder="2025" class="w-full border p-2 rounded">
                </div>
                <div class="flex items-center mb-2">
                    <input type="checkbox" name="is_active" id="bactive" value="1" checked class="mr-2 h-4 w-4">
                    <label for="bactive">Active</label>
                </div>
                <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded hover:bg-indigo-700">Save</button>
            </form>

            <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider text-gray-500">Name</th>
                            <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider text-gray-500">Program / Year</th>
                            <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider text-gray-500">Status</th>
                            <th class="px-6 py-3 text-right text-xs font-medium uppercase tracking-wider text-gray-500">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php while($row = $batches->fetch_assoc()): ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?= e($row['name']) ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= e($row['program']) ?> (<?= e($row['year']) ?>)</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm">
                                <span class="px-2 py-1 rounded text-xs <?= $row['is_active'] ? 'bg-green-100 text-green-800':'bg-gray-100 text-gray-800' ?>">
                                    <?= $row['is_active'] ? 'Active':'Inactive' ?>
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm">
                                <button type="button" onclick='editBatch(<?= json_encode($row) ?>)' class="text-indigo-600 hover:text-indigo-900">Edit</button>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</div>
<script>
function editBatch(b) {
    document.getElementById('bid').value = b.id;
    document.getElementById('bname').value = b.name;
    document.getElementById('bprog').value = b.program;
    document.getElementById('byear').value = b.year;
    document.getElementById('bactive').checked = b.is_active == 1;
}
</script>
<?php tailwind_foot(); ?>