<?php
// lib/functions.php

function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

function is_logged_in() {
    return isset($_SESSION['user_id']);
}

function user() {
    return $_SESSION['user'] ?? null;
}

function require_login() {
    if (!is_logged_in()) {
        header("Location: ../login.php");
        exit;
    }
}

function require_role($role) {
    require_login();
    if ($_SESSION['user_role'] !== $role) {
        die("Access Denied: You do not have permission to view this page.");
    }
}

function tailwind_head($title = "Lab Booking") {
    ?>
    <!DOCTYPE html>
    <html lang="en" class="h-full bg-slate-50">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?= e($title) ?></title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    </head>
    <body class="h-full font-sans text-slate-900">
    <?php
}

function tailwind_foot() {
    echo "</body></html>";
}

function overlap_exists($lab_id, $start, $end, $exclude_booking_id = null) {
    global $conn;
    $sql = "SELECT id FROM bookings 
            WHERE lab_id = ? 
            AND status IN ('pending', 'approved')
            AND (? < end_time AND ? > start_time)";
    $types = "iss";
    $params = [$lab_id, $end, $start];
    if ($exclude_booking_id) {
        $sql .= " AND id != ?";
        $types .= "i";
        $params[] = $exclude_booking_id;
    }
    $stmt = $conn->prepare($sql);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $stmt->store_result();
    return $stmt->num_rows > 0;
}

// --- NEW NOTIFICATION FUNCTIONS ---

function notify($user_id, $message, $link = null) {
    global $conn;
    $stmt = $conn->prepare("INSERT INTO notifications (user_id, message, link) VALUES (?, ?, ?)");
    $stmt->bind_param("iss", $user_id, $message, $link);
    $stmt->execute();
}

function get_unread_count($user_id) {
    global $conn;
    // Ensure connection is valid
    if (!$conn) return 0;
    
    $result = $conn->query("SELECT COUNT(*) FROM notifications WHERE user_id = $user_id AND is_read = 0");
    if ($result) {
        return $result->fetch_row()[0];
    }
    return 0;
}
?>